/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2016 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::timeVaryingMappedFixedValueFvPatchField

Group
    grpInletBoundaryConditions grpCoupledBoundaryConditions

Description
    This boundary conditions interpolates the values from a set of supplied
    points in space and time.

    Supplied data should be specified in constant/boundaryData/\<patchname\>/
      - points             : pointField of locations
      - \<time\>/\<field\> : field of values at time \<time\>

    The default mode of operation (mapMethod = planar) is to project
    the points onto a plane (constructed from the first three points) and
    construct a 2D triangulation and finds for the face centres the triangle it
    is in and the weights to the 3 vertices.

    The optional mapMethod nearest will avoid all projection and triangulation
    and just use the value at the nearest vertex.

    Values are interpolated linearly between times.

Usage
    \table
        Property     | Description                      | Required | Default
        setAverage   | Use average value                | no | false
        perturb      | Perturb points for regular geometries | no | 1e-5
        points       | Name of points file              | no | points
        fieldTable   | Alternative field name to sample | no | this field name
        mapMethod    | Type of mapping                  | no | planar
        offset       | Offset to mapped values          | no | Zero
    \endtable

    \verbatim
    <patchName>
    {
        type            timeVaryingMappedFixedValue;
    }
    \endverbatim

-------------------------------------------------->
extenstion of the boundary condition (by. M.sato)

spaceTimeVaryingMappedFixedValue is a variant of timeVaryingMappedFixedValue.
the boundary condition is composed as the product of spatial-pattern and
time-pattern.

spatial-pattern is obtained from the same data as above:

    constant/boundaryData/\<patchname\>/
      - points             : pointField of locations
      - \<time\>/\<field\> : field of values at time \<time\>

but only one-time-step data should be specified because these are used to
create only spatial pattern.
another required data is temporal-pattern; the keyword to specify time pattern
is "timePattern". this keyword is treated as function1 object, so that
any function1 method can be used, such as, table, tableFile, csvFile,...,etc.

in addition to these parameters, "scaling" is also needed which is used to
adjust the boundary value (because spatial and time pattern represent merely patterns
and to get real value we have to adjust the value)

typical input data seems below

    inlet
    {
        type            spaceTimeVaryingMappedFixedValue;
        mapMethod       nearest;
        scaling         8.587e6;
        timePattern     tableFile;
        timePatternCoeffs
        {
            file        "$FOAM_CASE/constant/timeData/pulse.dat";
            interpolationScheme linear;
            outOfBounds     repeat;
        }
    }

<--------------------------------------------------


See also
    Foam::fixedValueFvPatchField
    Foam::Function1Types

SourceFiles
    timeVaryingMappedFixedValueFvPatchField.C

\*---------------------------------------------------------------------------*/

#ifndef Foam_spaceTimeVaryingMappedFixedValueFvPatchField_H
#define Foam_spaceTimeVaryingMappedFixedValueFvPatchField_H

#include "fixedValueFvPatchFields.H"
#include "MappedFile.H"
#include "Function1.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

/*---------------------------------------------------------------------------*\
          Class spaceTimeVaryingMappedFixedValueFvPatchField Declaration
\*---------------------------------------------------------------------------*/

template<class Type>
class spaceTimeVaryingMappedFixedValueFvPatchField
:
    public fixedValueFvPatchField<Type>
{
    // Private Data

//      autoPtr<PatchFunction1Types::MappedFile<Type>> uniformValue_;
        autoPtr<PatchFunction1Types::MappedFile<Type>> spacePattern_;

        autoPtr<Function1<scalar>> timePattern_;

	scalar scaling_;

public:

    //- Runtime type information
    TypeName("spaceTimeVaryingMappedFixedValue");


    // Constructors

        //- Construct from patch and internal field
        spaceTimeVaryingMappedFixedValueFvPatchField
        (
            const fvPatch&,
            const DimensionedField<Type, volMesh>&
        );

        //- Construct from patch, internal field and dictionary
        spaceTimeVaryingMappedFixedValueFvPatchField
        (
            const fvPatch&,
            const DimensionedField<Type, volMesh>&,
            const dictionary&
        );

        //- Construct by mapping given spaceTimeVaryingMappedFixedValueFvPatchField
        //  onto a new patch
        spaceTimeVaryingMappedFixedValueFvPatchField
        (
            const spaceTimeVaryingMappedFixedValueFvPatchField<Type>&,
            const fvPatch&,
            const DimensionedField<Type, volMesh>&,
            const fvPatchFieldMapper&
        );

        //- Construct as copy
        spaceTimeVaryingMappedFixedValueFvPatchField
        (
            const spaceTimeVaryingMappedFixedValueFvPatchField<Type>&
        );

        //- Construct as copy setting internal field reference
        spaceTimeVaryingMappedFixedValueFvPatchField
        (
            const spaceTimeVaryingMappedFixedValueFvPatchField<Type>&,
            const DimensionedField<Type, volMesh>&
        );

        //- Return a clone
        virtual tmp<fvPatchField<Type>> clone() const
        {
            return fvPatchField<Type>::Clone(*this);
        }

        //- Clone with an internal field reference
        virtual tmp<fvPatchField<Type>> clone
        (
            const DimensionedField<Type, volMesh>& iF
        ) const
        {
            return fvPatchField<Type>::Clone(*this, iF);
        }


    // Member functions

        // Mapping functions

            //- Map (and resize as needed) from self given a mapping object
            virtual void autoMap
            (
                const fvPatchFieldMapper&
            );

            //- Reverse map the given fvPatchField onto this fvPatchField
            virtual void rmap
            (
                const fvPatchField<Type>&,
                const labelList&
            );


        // Evaluation functions

            //- Update the coefficients associated with the patch field
            virtual void updateCoeffs();


        //- Write
        virtual void write(Ostream&) const;
};


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#ifdef NoRepository
    #include "spaceTimeVaryingMappedFixedValueFvPatchField.C"
#endif

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
